@echo off
echo ****************************************************************************
echo Un-installing Muhimbi PDF Editor for SharePoint.    (c) 2022 www.muhimbi.com
echo ****************************************************************************
echo.

REM ** Detect which version of SharePoint is installed.
echo - Detecting SharePoint Version
set SharePointVersion=2016_19
set STSADM="%CommonProgramFiles%\Microsoft Shared\Web Server Extensions\16\bin\STSADM.EXE"
set TimerServiceName="SharePoint Timer Service"
set SolutionWSP=Muhimbi.PDFEditor.SP2019-SE.wsp
if exist %STSADM% goto endVersionDetection
	echo - SharePoint 2016 or 2019 does not appear to be installed on this server.
	goto endOfScript
:endVersionDetection
echo - SharePoint found, version: %SharePointVersion%

echo - Enabling SharePoint Administration Service
net start "SharePoint Administration"

echo - Retracting solution.
%STSADM% -o retractsolution -name %SolutionWSP% -immediate
%STSADM% -o execadmsvcjobs

echo - Wait for the solution to be retracted across the farm (Check Central Admin).
pause

echo - Removing solution from Store.
%STSADM% -o deletesolution -name %SolutionWSP%
%STSADM% -o execadmsvcjobs

echo - Restarting timer service in order to release any GAC DLLs.
net stop %TimerServiceName%
net start %TimerServiceName%

echo - Un-installation finished.

:endOfScript

echo.
pause
