﻿Write-Host '*******************************************************************************'
Write-Host 'Un-installing Muhimbi PDF Editor for SharePoint.       (c) 2022 www.muhimbi.com'
Write-Host '*******************************************************************************'
Write-Host ''

if ((Get-PSSnapin -Name Microsoft.SharePoint.PowerShell -ErrorAction SilentlyContinue) -eq $null) {
    Write-Host '- Adding PSSnapin Microsoft.SharePoint.PowerShell'
    Add-PSSnapin Microsoft.SharePoint.PowerShell
} else {
    Write-Host '- PSSnapin Microsoft.SharePoint.PowerShell is already added'
}

Write-Host '- Detecting SharePoint version'
$spProduct = Get-SPProduct -Local
If($spProduct.ProductName -eq 'Microsoft SharePoint Server Subscription Edition') {
    Write-Host '- SharePoint Server Subscription Edition found.'
} Else {
    Write-Host '- SharePoint Server Subscription Edition does not appear to be installed on this server.'
    exit
}

$solutionWSP = 'Muhimbi.PDFEditor.SP2019-SE.wsp'

Write-Host '- Enabling SharePoint Administration Service'
Start-Service 'SharePoint Administration'

Write-Host '- Retracting solution.'
Uninstall-SPSolution –Identity $solutionWSP -Confirm:$false

Write-Host ''
Write-Host -ForegroundColor Yellow '- Wait for the solution to be retracted across the farm (Check Central Admin).'
Write-Host 'Press any key to continue...';
$null = $Host.UI.RawUI.ReadKey('NoEcho,IncludeKeyDown');

Write-Host ''
Write-Host '- Removing solution from Store.'
Remove-SPSolution –Identity $solutionWSP -Force -Confirm:$false

Write-Host '- Restarting timer service in order to release any GAC DLLs.'
Stop-Service 'SharePoint Timer Service'
Start-Service 'SharePoint Timer Service'

Write-Host '- Un-installation finished.'
Write-Host ''
Write-Host 'Press any key to continue...';
$null = $Host.UI.RawUI.ReadKey('NoEcho,IncludeKeyDown');
exit