@echo off
echo ****************************************************************************
echo Installing Muhimbi PDF Editor for SharePoint.       (c) 2022 www.muhimbi.com
echo ****************************************************************************
echo.

REM ** Detect which version of SharePoint is installed.
echo - Detecting SharePoint Version
set SharePointVersion=2016_19
set STSADM="%CommonProgramFiles%\Microsoft Shared\Web Server Extensions\16\bin\STSADM.EXE"
set TimerServiceName="SharePoint Timer Service"
set SolutionWSP=Muhimbi.PDFEditor.SP2019-SE.wsp
if exist %STSADM% goto endVersionDetection
	echo - SharePoint 2016 or 2019 does not appear to be installed on this server.
	goto endOfScript
:endVersionDetection
echo - SharePoint found, version: %SharePointVersion%

echo - Enabling SharePoint Administration Service
net start "SharePoint Administration"

echo - Starting timer service
net start %TimerServiceName%

echo - Adding solution to Solution Store
%STSADM% -o addsolution -filename "%~dp0%SolutionWSP%"
%STSADM% -o execadmsvcjobs

echo - Deploying solution
%STSADM% -o deploysolution -name %SolutionWSP% -immediate -allowgacdeployment -force

echo - Feature is self activating

echo - If you are experiencing problems when accessing the solution then
echo   please read the Administration guide.

echo - Installation finished.

:endOfScript

echo.
pause
