﻿Write-Host '****************************************************************************'
Write-Host 'Installing Muhimbi PDF Editor for SharePoint.       (c) 2022 www.muhimbi.com'
Write-Host '****************************************************************************'
Write-Host ''

if ((Get-PSSnapin -Name Microsoft.SharePoint.PowerShell -ErrorAction SilentlyContinue) -eq $null) {
    Write-Host '- Adding PSSnapin Microsoft.SharePoint.PowerShell'
    Add-PSSnapin Microsoft.SharePoint.PowerShell
} else {
    Write-Host '- PSSnapin Microsoft.SharePoint.PowerShell is already added'
}

Write-Host '- Detecting SharePoint version'
$spProduct = Get-SPProduct -Local
If($spProduct.ProductName -eq 'Microsoft SharePoint Server Subscription Edition') {
    Write-Host '- SharePoint Server Subscription Edition found.'
} Else {
    Write-Host '- SharePoint Server Subscription Edition does not appear to be installed on this server.'
    exit
}

$solutionWSP = 'Muhimbi.PDFEditor.SP2019-SE.wsp'

Write-Host '- Enabling SharePoint Administration Service'
Start-Service 'SharePoint Administration'

Write-Host '- Starting timer service'
Start-Service 'SharePoint Timer Service'

Write-Host '- Adding solution to Solution Store'
Add-SPSolution -LiteralPath $(Get-Childitem $solutionWSP)

Write-Host ''
Write-Host '- Deploying solution'
Install-SPSolution –Identity $solutionWSP -GACDeployment -Force
Write-Host '- Feature is self activating'
Write-Host '- If you are experiencing problems when accessing the solution then please read the Administration guide.'
Write-Host '- Installation finished.'
Write-Host ''
Write-Host 'Press any key to continue...';
$null = $Host.UI.RawUI.ReadKey('NoEcho,IncludeKeyDown');
exit